// 020Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "020.h"
#include "020Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "umfh.H"

#pragma comment(lib,"umf.lib")


unsigned int PortType; 
int icdev ;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy020Dlg dialog

CMy020Dlg::CMy020Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMy020Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy020Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMy020Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy020Dlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMy020Dlg, CDialog)
	//{{AFX_MSG_MAP(CMy020Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5)
	ON_BN_CLICKED(IDC_BUTTON6, OnButton6)
	ON_BN_CLICKED(IDC_BUTTON7, OnButton7)
	ON_BN_CLICKED(IDC_BUTTON8, OnButton8)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy020Dlg message handlers

BOOL CMy020Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_list = (CListBox*)GetDlgItem(IDC_LIST1);
	m_rdBtnUSB = (CButton*)GetDlgItem(IDC_RADIO1);
	m_comb = (CComboBox*)GetDlgItem(IDC_COMBO1);

	SetDlgItemInt(IDC_EDIT1,4);
	SetDlgItemText(IDC_EDIT2,"9999999999999999");


	m_rdBtnUSB->SetCheck(1);
	m_comb->SetCurSel(0);


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMy020Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMy020Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMy020Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

int CMy020Dlg::GetDeviceHandle()
{

	if(m_rdBtnUSB->GetCheck())
	{
		return fw_init(100,0);
	}
	else
	{
		return fw_init(m_comb->GetCurSel(),115200);
	}

}



void CMy020Dlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	

	unsigned char mode = 0;
	unsigned char afi =0;
	unsigned char adr = 2;
	unsigned char cid = 0x01;
	unsigned char ATQB[15];
	unsigned char UID[128];
	int status;
	unsigned char key[9]={0};
	unsigned char rbuf[128];
	CString strShow;
	int i;

	status = fw_request_b((HANDLE)icdev,mode,afi,0,ATQB);
	if(status !=0)
	{
		m_list->AddString ("fw_request error.");
		goto _exit;
	}

	memcpy(UID,&ATQB[1],0x04);

	status = fw_attrib((HANDLE)icdev,UID,cid);

	if(status !=0)
	{
		m_list->AddString ("fw_attrib error");
		goto _exit;
	}

	status = fw_check_at((HANDLE)icdev,cid,key);
	if(status !=0)
	{
		m_list->AddString ("fw_check_at error");
		goto _exit;
	}

	adr = GetDlgItemInt(IDC_EDIT1);

	for(i=0; i< 32; i++)
	{
		status = fw_read_at((HANDLE)icdev,i,key,rbuf);
		if(status !=0)
		{
			m_list->AddString ("fw_read error");
			//goto _exit;
		}
		
		strShow.Format("[%02d]: %02X %02X %02X %02X %02X %02X %02X %02X",i,rbuf[0],rbuf[1],rbuf[2],rbuf[3],rbuf[4],rbuf[5],rbuf[6],rbuf[7]);
		m_list->AddString (strShow);
	}


_exit:
	return ;



}

void CMy020Dlg::OnButton2() 
{
	// TODO: Add your control notification handler code here

	unsigned char mode = 0;
	unsigned char afi =0;
	unsigned char adr = 2;
	unsigned char cid = 0x01;
	unsigned char ATQB[1024];
	unsigned char UID[128];
	int status;
	unsigned char key[9]={0};
	unsigned char wbuf[1024];
	CString strShow, strText;
	unsigned char szText[1024];

	status = fw_request_b((HANDLE)icdev,mode,afi,0,ATQB);

	if(status !=0)
	{
		m_list->AddString ("fw_request error.");
		goto _exit;
	}

	memcpy(UID,&ATQB[1],0x04);

	status = fw_attrib((HANDLE)icdev,UID,cid);

	if(status !=0)
	{
		m_list->AddString ("fw_attrib error");
		goto _exit;
	}

	status = fw_check_at((HANDLE)icdev,cid,key);
	if(status !=0)
	{
		m_list->AddString ("fw_check_at error");
		goto _exit;
	}

	adr = GetDlgItemInt(IDC_EDIT1);

	GetDlgItemText(IDC_EDIT2,strText);

	memcpy(szText,strText.GetBuffer(strText.GetLength ()),strText.GetLength ());
	

	a_hex(wbuf,szText,strText.GetLength()/2);

	strText.ReleaseBuffer ();

	status = fw_write_at((HANDLE)icdev,adr,wbuf);
	if(status !=0)
	{
		m_list->AddString ("write error");
		goto _exit;
	}

	
	m_list->AddString ("write ok");


_exit:
	return ;
}

void CMy020Dlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
	unsigned char mode = 0;
	unsigned char afi =0;
	unsigned char adr = 2;
	unsigned char cid = 0x00;//cid must be set to 0x00!!
	unsigned char ATQB[1024];
	unsigned char UID[128];
	int status;
	unsigned char key[9]={0};
	unsigned char newKey[1024] ={0};//{0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88};
	CString strShow;

	status = fw_request_b((HANDLE)icdev,mode,afi,0,ATQB);

	if(status !=0)
	{
		m_list->AddString ("fw_request error.");
		goto _exit;
	}

	memcpy(UID,&ATQB[1],0x04);

	status = fw_attrib((HANDLE)icdev,UID,cid);

	if(status !=0)
	{
		m_list->AddString ("fw_attrib error");
		goto _exit;
	}

	status = fw_check_at((HANDLE)icdev,cid,key);
	if(status !=0)
	{
		m_list->AddString ("fw_check_at error");
		goto _exit;
	}

	adr = GetDlgItemInt(IDC_EDIT1);



	//status = fw_changekey_at((HANDLE)icdev,newKey);
	if(status !=0)
	{
		m_list->AddString ("fw_changekey_at error");
		goto _exit;
	}

	status = fw_halt_at((HANDLE)icdev,cid,key);
	if(status !=0)
	{
		m_list->AddString ("fw_halt_at error");
		goto _exit;
	}
	
	m_list->AddString ("fw_changekey_at ok");


_exit:
	return ;
}

void CMy020Dlg::OnButton4() 
{
	// TODO: Add your control notification handler code here

	unsigned char mode = 0;
	unsigned char afi =0;
	unsigned char adr = 2;
	unsigned char cid = 0x00;////cid must be set to 0x00!!
	unsigned char ATQB[1024];
	unsigned char UID[128];
	int status;
	unsigned char key[9]={0};
	unsigned char wbuf[1024] ={0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88};
	CString strShow;
	
	status = fw_request_b((HANDLE)icdev,mode,afi,0,ATQB);

	if(status !=0)
	{
		m_list->AddString ("fw_request error.");
		goto _exit;
	}

	memcpy(UID,&ATQB[1],0x04);

	status = fw_attrib((HANDLE)icdev,UID,cid);

	if(status !=0)
	{
		m_list->AddString ("fw_attrib error");
		goto _exit;
	}

	status = fw_check_at((HANDLE)icdev,cid,key);
	if(status !=0)
	{
		m_list->AddString ("fw_check_at error");
		goto _exit;
	}

	adr = GetDlgItemInt(IDC_EDIT1);

	status = fw_lock_at((HANDLE)icdev,adr,wbuf);
	if(status !=0)
	{
		m_list->AddString ("fw_lock_at error");
		goto _exit;
	}

	
	m_list->AddString ("fw_lock_at ok");


_exit:
	return ;
}

void CMy020Dlg::OnButton5() 
{
	// TODO: Add your control notification handler code here
	unsigned char mode = 0;
	unsigned char afi =0;
	unsigned char adr = 2;
	unsigned char cid = 0x00;////cid must be set to 0x00!!
	unsigned char ATQB[1024];
	unsigned char UID[128];
	int status;
	unsigned char key[9]={0};
	CString strShow;

	status = fw_request_b((HANDLE)icdev,mode,afi,0,ATQB);

	if(status !=0)
	{
		m_list->AddString ("fw_request error.");
		goto _exit;
	}

	memcpy(UID,&ATQB[1],0x04);

	status = fw_attrib((HANDLE)icdev,UID,cid);

	if(status !=0)
	{
		m_list->AddString ("fw_attrib error");
		goto _exit;
	}

	status = fw_check_at((HANDLE)icdev,cid,key);
	if(status !=0)
	{
		m_list->AddString ("fw_check_at error");
		goto _exit;
	}

	status = fw_count_at((HANDLE)icdev,cid,key);
	if(status !=0)
	{
		m_list->AddString ("fw_count_at error");
		goto _exit;
	}

	
	m_list->AddString ("fw_count_at ok");


_exit:
	return ;
}



void CMy020Dlg::OnButton6() 
{
	// TODO: Add your control notification handler code here
	int status ;

	icdev = GetDeviceHandle();
 
 	if(icdev == -1)
	{
 		m_list->AddString ("Link device error");
		return;
	}
	m_list->AddString ("Link device ok");

 	status = fw_config_card((HANDLE)icdev,0x42);
 	if(status !=0)
 	{
		m_list->AddString ("config card error");
		goto _exit;
 	}
	//m_list->AddString ("config card ok");

_exit:
	return ;
 	//
}

void CMy020Dlg::OnButton7() 
{
	// TODO: Add your control notification handler code here
	m_list->ResetContent() ;
	
}

void CMy020Dlg::OnButton8() 
{
	// TODO: Add your control notification handler code here
	fw_exit(icdev);
	CDialog::OnOK(); 
	//this->OnCancel ;
}
